/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.io.Serializable;
import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.IndexingException;
import org.python.indexer.Scope;
import org.python.indexer.ast.GenericNodeVisitor;
import org.python.indexer.ast.NCall;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NNode
implements Serializable {
    static final long serialVersionUID = 3682719481356964898L;
    private int start = 0;
    private int end = 1;
    protected NNode parent = null;
    private transient NType type;

    public NNode() {
        this.type = Indexer.idx.builtins.None;
    }

    public NNode(int n, int n2) {
        this.type = Indexer.idx.builtins.None;
        this.setStart(n);
        this.setEnd(n2);
    }

    public void setParent(NNode nNode) {
        this.parent = nNode;
    }

    public NNode getParent() {
        return this.parent;
    }

    public NNode getAstRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getAstRoot();
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public Scope getTable() {
        return this.getType().getTable();
    }

    public NType getType() {
        if (this.type == null) {
            this.type = Indexer.idx.builtins.None;
        }
        return this.type;
    }

    public NType setType(NType nType) {
        if (nType == null) {
            throw new IllegalArgumentException();
        }
        this.type = nType;
        return this.type;
    }

    public NType addType(NType nType) {
        if (nType == null) {
            throw new IllegalArgumentException();
        }
        this.type = NUnionType.union(this.getType(), nType);
        return this.type;
    }

    public boolean bindsName() {
        return false;
    }

    protected void bindNames(Scope scope) throws Exception {
        throw new UnsupportedOperationException("Not a name-binding node type");
    }

    public String getFile() {
        return this.parent != null ? this.parent.getFile() : null;
    }

    public void addChildren(NNode ... nNodeArray) {
        if (nNodeArray != null) {
            for (NNode nNode : nNodeArray) {
                if (nNode == null) continue;
                nNode.setParent(this);
            }
        }
    }

    public void addChildren(List<? extends NNode> list) {
        if (list != null) {
            for (NNode nNode : list) {
                if (nNode == null) continue;
                nNode.setParent(this);
            }
        }
    }

    private static NType handleExceptionInResolve(NNode nNode, Throwable throwable) {
        Indexer.idx.handleException("Unable to resolve: " + nNode + " in " + nNode.getFile(), throwable);
        return new NUnknownType();
    }

    public static NType resolveExpr(NNode nNode, Scope scope) {
        if (nNode == null) {
            return new NUnknownType();
        }
        try {
            NType nType = nNode.resolve(scope);
            if (nType == null) {
                Indexer.idx.warn(nNode + " resolved to a null type");
                return nNode.setType(new NUnknownType());
            }
            return nType;
        }
        catch (IndexingException indexingException) {
            throw indexingException;
        }
        catch (Exception exception) {
            return NNode.handleExceptionInResolve(nNode, exception);
        }
        catch (StackOverflowError stackOverflowError) {
            String string = "Unable to resolve: " + nNode + " in " + nNode.getFile() + " (stack overflow)";
            Indexer.idx.warn(string);
            return NNode.handleExceptionInResolve(nNode, stackOverflowError);
        }
    }

    public NType resolve(Scope scope) throws Exception {
        return this.getType();
    }

    public boolean isCall() {
        return this instanceof NCall;
    }

    public boolean isModule() {
        return this instanceof NModule;
    }

    public boolean isClassDef() {
        return false;
    }

    public boolean isFunctionDef() {
        return false;
    }

    public boolean isLambda() {
        return false;
    }

    public boolean isName() {
        return this instanceof NName;
    }

    protected void visitNode(NNode nNode, NNodeVisitor nNodeVisitor) {
        if (nNode != null) {
            nNode.visit(nNodeVisitor);
        }
    }

    protected void visitNodeList(List<? extends NNode> list, NNodeVisitor nNodeVisitor) {
        if (list != null) {
            for (NNode nNode : list) {
                if (nNode == null) continue;
                nNode.visit(nNodeVisitor);
            }
        }
    }

    public abstract void visit(NNodeVisitor var1);

    public Scope getEnclosingNamespace() {
        if (this.parent == null || this.isModule()) {
            return Indexer.idx.globaltable;
        }
        NNode nNode = this;
        while ((nNode = nNode.parent) != null) {
            if (!nNode.isFunctionDef() && !nNode.isClassDef() && !nNode.isModule()) continue;
            NType nType = nNode.getType();
            if (nType == null || nType.getTable() == null) {
                return Indexer.idx.globaltable;
            }
            return nType.getTable();
        }
        return Indexer.idx.globaltable;
    }

    protected void addWarning(String string) {
        Indexer.idx.putProblem(this, string);
    }

    protected void addWarning(NNode nNode, String string) {
        Indexer.idx.putProblem(nNode, string);
    }

    protected void addError(String string) {
        Indexer.idx.putProblem(this, string);
    }

    protected void addError(NNode nNode, String string) {
        Indexer.idx.putProblem(nNode, string);
    }

    protected NType resolveListAsUnion(List<? extends NNode> list, Scope scope) {
        if (list == null || list.isEmpty()) {
            return new NUnknownType();
        }
        NType nType = null;
        for (NNode nNode : list) {
            NType nType2 = NNode.resolveExpr(nNode, scope);
            if (nType == null) {
                nType = nType2;
                continue;
            }
            nType = NUnionType.union(nType, nType2);
        }
        return nType;
    }

    protected void resolveList(List<? extends NNode> list, Scope scope) {
        if (list != null) {
            for (NNode nNode : list) {
                NNode.resolveExpr(nNode, scope);
            }
        }
    }

    public NNode getDeepestNodeAtOffset(int n) {
        NNode nNode = this.getAstRoot();
        DeepestOverlappingNodeFinder deepestOverlappingNodeFinder = new DeepestOverlappingNodeFinder(n);
        try {
            nNode.visit(deepestOverlappingNodeFinder);
        }
        catch (NNodeVisitor.StopIterationException stopIterationException) {
            // empty catch block
        }
        return deepestOverlappingNodeFinder.getNode();
    }

    static class DeepestOverlappingNodeFinder
    extends GenericNodeVisitor {
        private int offset;
        private NNode deepest;

        public DeepestOverlappingNodeFinder(int n) {
            this.offset = n;
        }

        public NNode getNode() {
            return this.deepest;
        }

        public boolean dispatch(NNode nNode) {
            if (this.offset > nNode.end) {
                return false;
            }
            if (this.offset >= nNode.start && this.offset <= nNode.end) {
                this.deepest = nNode;
                return true;
            }
            throw new NNodeVisitor.StopIterationException();
        }
    }
}

